﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections.ObjectModel;
using System.ComponentModel.DataAnnotations;

namespace FlexGridIntro
{
    public class Person
    {
        internal static string[] Countries = "China|India|United States|Indonesia|Brazil|Pakistan|Bangladesh|Nigeria|Russia|Japan|Mexico|Philippines|Vietnam|Germany|Ethiopia|Egypt|Iran|Turkey|Congo|France|Thailand|United Kingdom|Italy|Myanmar".Split('|');

        #region ctor

        public Person()
        {
            
        }

        #endregion

        #region Object Model

        public int ID { get; set; }
        //public string Name { get { return string.Format("{0} {1}", First, Last); } }
        //public string Country { get { return Countries[CountryID]; } }
        public int CountryID { get; set; }
        public bool Active { get; set; }
        public string First { get; set; }
        public string Last { get; set; }
        public DateTime Hired { get; set; }
        public double Sales { get; set; }
        public double Downloads { get; set; }

        #endregion
    }
    public class ProductSales
    {
        public int ID { get; set; }
        public string First { get; set; }
        public string Batch { get; set; }
        public string Name { get; set; }
        public int Amount { get; set; }
    }

    public class SampleData
    {
        private static Random _rnd = new Random();
        private static string[] _firstNames = "Andy|Ben|Charlie|Dan|Ed|Fred|Gil|Herb|Jack|Karl|Larry|Mark|Noah|Oprah|Paul|Quince|Rich|Steve|Ted|Ulrich|Vic|Xavier|Zeb".Split('|');
        private static string[] _lastNames = "Ambers|Bishop|Cole|Danson|Evers|Frommer|Griswold|Heath|Jammers|Krause|Lehman|Myers|Neiman|Orsted|Paulson|Quaid|Richards|Stevens|Trask|Ulam".Split('|');
        private static string[] _productSales = "Spread,ComponentOne,Wijmo,Active".Split(',');
        private static string GetString(string[] arr,int index)
        {
            return arr[index%arr.Length];
        }
        private static int _personCount;
            
        public static IEnumerable<ProductSales> GetProductSales()
        {
            Random _rnd = new Random();
            var list = Enumerable.Range(0, SampleData._personCount * 2).Select(i => {
                return new ProductSales()
                {
                    ID = i % SampleData._personCount,
                    First = GetString(_firstNames,i),
                    Batch = "PRD" + i.ToString(),
                    Amount= _rnd.Next(10000,90000),
                    Name = _productSales[i% _productSales.Length]
                };
            });
            return list;
        }
        public static IEnumerable<Person> GetData(int count)
        {
            SampleData._personCount = count;
            var list = Enumerable.Range(0, count).Select(i =>
            {
                return new Person()
                {
                    ID=i,
                    First = GetString(_firstNames, i),
                    Last = GetString(_lastNames, i),
                    CountryID = i % Person.Countries.Length,
                    Active = _rnd.NextDouble() >= .5,
                    Hired = DateTime.Today.AddDays(-_rnd.Next(1, 365)),
                    Sales = (_rnd.NextDouble() * 100) * (i % 3 ==0 ? -1 : 1),
                    Downloads = (_rnd.NextDouble() * 1000) * (i % 3 == 0 ? -1 : 1)
                };
            });
            return list;
        }
    }
}
